set echo off
set feedback off
set linesize 512

prompt
prompt Foreign Keys Missing Indexes
prompt

column column_name format a32
break on OWNER skip 1 on TABLE_NAME

SELECT	 ACC.OWNER, ACC.TABLE_NAME, ACC.CONSTRAINT_NAME, ACC.COLUMN_NAME,
		 ACC.POSITION
	FROM ALL_CONS_COLUMNS ACC, ALL_CONSTRAINTS AC
   WHERE ACC.OWNER NOT IN ('SYS','SYSTEM','OUTLN','DBSNMP')
	 AND AC.TABLE_NAME = ACC.TABLE_NAME
	 AND ACC.OWNER = AC.OWNER
	 AND AC.CONSTRAINT_NAME = ACC.CONSTRAINT_NAME
	 AND AC.CONSTRAINT_TYPE = 'R'
	 AND (ACC.OWNER, ACC.TABLE_NAME, ACC.COLUMN_NAME, ACC.POSITION) IN
			   (SELECT ACC.OWNER, ACC.TABLE_NAME,
					   ACC.COLUMN_NAME,
					   ACC.POSITION
				  FROM ALL_CONS_COLUMNS ACC, ALL_CONSTRAINTS AC
				 WHERE AC.CONSTRAINT_NAME = ACC.CONSTRAINT_NAME
				   AND AC.CONSTRAINT_TYPE = 'R'
				MINUS
				SELECT TABLE_OWNER, TABLE_NAME, COLUMN_NAME, COLUMN_POSITION
				  FROM ALL_IND_COLUMNS)
ORDER BY ACC.OWNER, ACC.CONSTRAINT_NAME, ACC.COLUMN_NAME, ACC.POSITION;